package mcfall.raytracer.tests;

public abstract class TestCase extends junit.framework.TestCase {
	static double defaultTolerance = 0.001;
	
	public static void setDefaultTolerance (double newValue) {
		defaultTolerance = newValue;
	}
	
	public static void assertAlmostEquals (double expectedValue, double actualValue) {
		assertAlmostEquals(expectedValue, actualValue, defaultTolerance);
		
	}
	public static void assertAlmostEquals (double expectedValue, double actualValue, double tolerance) {
		assertTrue ("Expected value: " + expectedValue + " was " + actualValue, Math.abs(expectedValue-actualValue) < tolerance);
	}
}
